//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) The Optional Enum
//:
//: ## Task:
//:
//: Delete the `Optional3` enum below. Refactor the code to use the actual `Optional` enum declared in the Swfit standard library keeping to the long-form method of writing code.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


enum Optional3<T> {
    case none
    case some(T)
}

let anOptionalInt: Optional3<Int> = .some(100)
if case Optional3.some(
    let unwrappedValue) = anOptionalInt {
    print(unwrappedValue)
} else {
    print("No value exists")
}


//:
//: -------------------
//:
//: ## Task:
//:
//: Refactor the code above to use the short-form method of writing optionals. 
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
